////////////////////////////////////////////////////////////////////////////////////
// MultiLanguage.cpp
#include "stdafx.h"
#include "MultiLanguage.h"

CString CMultiLanguage::m_strInilangFilePath;//ini language file full path(inlude filename)

CMultiLanguage::CMultiLanguage()
{

}

CMultiLanguage::~CMultiLanguage()
{
}

//////////////////////////////////////////////////////////////
//English stringconvert to current language string
CString CMultiLanguage::ConvertString(CString strText)
{
	TCHAR val[300];
	CString strRet;
	
	if (m_strInilangFilePath.GetLength())
	{
		memset(val,0,sizeof(val));
		GetPrivateProfileString(_T("String"),strText,_T(""), val,sizeof(val)/sizeof(TCHAR),m_strInilangFilePath);
		strRet=val;
		if(strRet.GetLength()> 0)
		{
			return strRet;	
		}
	}
	
	const TCHAR *p = _tcsstr(strText, _T("."));
	if (p)
	{
		strRet = p + 1;
	}
	else
	{
		strRet = strText;
	}
	return strRet;
}

// set ini file about transfering multi-language text
BOOL CMultiLanguage::SetIniFileName(LPCTSTR szLanguageIniFileName)
{	
	BOOL flag = TRUE;
	TCHAR cVal[64] = {0};
	CString strRet;
	CString strConfig = szLanguageIniFileName;
	LCID lcid = GetSystemDefaultLCID();

	TCHAR szFull[_MAX_PATH];
	::GetModuleFileName(NULL, szFull, sizeof(szFull)/sizeof(TCHAR));
	strConfig += _T("Config.ini");
	GetPrivateProfileString(_T("themes"), _T("Solution"), _T(""), cVal, 
		sizeof(cVal) / sizeof(TCHAR), strConfig);
	strRet = cVal;
	if(strRet.GetLength()==0)
	{
		//if there is no equal string in .inidocumentset the default languageEnglish
		if ((lcid & 0xff) == 0x09)//English
			strRet = _T("English");
		else if ((lcid & 0xff) == 0x04)//SimpChinese
			strRet = _T("SimpChinese");
		else
			strRet = _T("English");
		
		//WritePrivateProfileString(_T("themes"), _T("Solution"), _T("English"), strConfig);
		flag = FALSE;
	}
	m_strInilangFilePath = szLanguageIniFileName;
	m_strInilangFilePath += _T("Language\\");
	m_strInilangFilePath += strRet + _T(".lang");
	return flag;
}

//////////////////////////////////////////////////////////////
//set the static text in dialog(English to current language)
void CMultiLanguage::SetWndStaticText(CWnd * pWnd)
{
	CString strCaption,strText;

	//set the window text of main windows	
	pWnd->GetWindowText(strCaption);
	if(strCaption.GetLength()>0)
	{
		strText=ConvertString(strCaption);
		pWnd->SetWindowText(strText);
	}

	//set the window text of child windows
	CWnd * pChild=pWnd->GetWindow(GW_CHILD);
	CString strClassName;
	while(pChild)
	{
		//////////////////////////////////////////////////////////////////////////		
		//Added by Jackbin 2005-03-11
		strClassName = ((CRuntimeClass*)pChild->GetRuntimeClass())->m_lpszClassName;
		if(strClassName == "CEdit" || strClassName == "CIPAddressCtrl" || strClassName == "CNetSurveillance")
		{
			//next child window
			pChild=pChild->GetWindow(GW_HWNDNEXT);
			continue;
		}
		//////////////////////////////////////////////////////////////////////////	
		//set the current text of child windows
		pChild->GetWindowText(strCaption);
		strText=ConvertString(strCaption);
		pChild->SetWindowText(strText);
		//next child window
		pChild=pChild->GetWindow(GW_HWNDNEXT);
	}
}

CString CMultiLanguage::GetCurrenLanguage()
{
	return m_strInilangFilePath;
}

void CMultiLanguage::SetCurrenLanguage(CString Language)
{
	CString Section = "themes";
	CString Key = "Solution";
	CString  inipath;
	GetModuleFileName(NULL, inipath.GetBufferSetLength(MAX_PATH + 1), MAX_PATH);
	inipath.ReleaseBuffer();
	int pos = inipath.ReverseFind('\\');
	inipath = inipath.Left(pos);
	//-----------------------------------------------
	m_strInilangFilePath = inipath + "\\";
	m_strInilangFilePath += _T("Language\\");
	m_strInilangFilePath += Language + _T(".lang");
	//-----------------------------------------------
	inipath = inipath + "\\Config.ini";
	WritePrivateProfileString((LPCTSTR)Section, (LPCTSTR)Key, (LPCTSTR)Language, (LPCTSTR)inipath);

}


